#region usings
using System;
using System.ComponentModel.Composition;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;
#endregion usings

namespace VVVV.Nodes
{
	#region PluginInfo
	[PluginInfo(Name = "MultipleLinesIntersect", Category = "Value", Help = "2 lines intersect", Tags = "")]
	//Source:
	//http://paulbourke.net/geometry/lineline2d/
	//Credits:
	//Lasal 2011
	
	#endregion PluginInfo
	public class Value2LinesIntersectNode : IPluginEvaluate
	{
		#region fields & pins
		
		// Could it be possible to use a spread of points?
		
		[Input("Line Start")]
		ISpread<Vector2D> P1;
		
		[Input("Line End")]
		ISpread<Vector2D> P2;
		
		[Output("Intersection")]
		ISpread<Vector2D> FIntersection;
		
		#endregion fields & pins
		
		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			FIntersection.SliceCount = 0;
			for (int i = 0; i < SpreadMax; i++)
			{
				for (int j = i + 1; j < SpreadMax; j++)
				{
					Vector2D s;
					if (LinesIntersection( P1[i], P2[i], P1[j], P2[j], out s))
					{
						FIntersection.Add(s);
					}
				}
			}
		}
		
		private bool LinesIntersection ( Vector2D P1 , Vector2D P2, Vector2D P3 , Vector2D P4, out Vector2D s)
		{
			s = new Vector2D();
			
			// Denominator for ua and ub are the same, so store this calculation
			double d =
			(P4.y - P3.y) * (P2.x - P1.x)
			-
			(P4.x - P3.x) * (P2.y - P1.y);
			
			//n_a and n_b are calculated as seperate values for readability
			double n_a =
			(P4.x - P3.x) * (P1.y - P3.y)
			-
			(P4.y - P3.y) * (P1.x - P3.x);
			
			double n_b =
			(P2.x - P1.x) * (P1.y - P3.y)
			-
			(P2.y - P1.y) * (P1.x - P3.x);
			
			// Parallel lines.
			if (d == 0)
			{
				return false;
			}
			
			// Calculate the intermediate fractional point that the lines potentially intersect.
			double ua = n_a / d;
			double ub = n_b / d;
			
			double SX = P1.x + (ua * (P2.x - P1.x));
			double SY = P1.y + (ua * (P2.y - P1.y));
			
			// No finite lines intersecting, delete this for infinite lines Intersection.
			if (
			(SX < P1.x && SX < P2.x) ||
			(SY < P1.y && SY < P2.y) ||
			(SX > P1.x && SX > P2.x) ||
			(SY > P1.y && SY > P2.y))
			{
				return false;
			}
			
			// The fractional point will be between 0 and 1 inclusive if the lines
			// intersect.  If the fractional calculation is larger than 1 or smaller
			// than 0 the lines would need to be longer to intersect.
			if (ua >= 0d && ua <= 1d && ub >= 0d && ub <= 1d)
			{
				s.x = SX;
				s.y = SY;
				return true;
			}
			return false;
		}
	}
}